﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;          // added to include serial ports
using System.Net;
using System.Net.Sockets;
using System.IO;
using System.Management;

namespace USB_RLY82_test
{
    public partial class Form1 : Form
    {
        static SerialPort USB_PORT;
        byte[] SerBuf = new byte[20];
        byte serial_written_flag = 0;
        bool init_setup = false;
        bool connected = false;

        public Form1()
        {
            InitializeComponent();
            USB_PORT = new SerialPort();
            string[] comportnames = new string[100];
            comportnames = SerialPort.GetPortNames();
            var sortedList = comportnames.OrderBy(port => Convert.ToInt32(port.Replace("COM", string.Empty)));

            foreach (string port in sortedList)
            {
                comboBox_comport.Items.Add(port);                      // places each "COMx" name into combobox
            }
            comboBox_comport.Text = "Select Port";              // printed only at first execution in the combobox
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            string tempstring;
            byte x;

            if (connected == true)
            {
                if (init_setup == true)
                {
                    SerBuf[0] = 0x82;       // get adc ref
                    transmit(1);
                    receive(8);
                    init_setup = false;
                    comboBox_adcref1.SelectedIndex = SerBuf[0];
                    comboBox_adcref2.SelectedIndex = SerBuf[1];
                    comboBox_adcref3.SelectedIndex = SerBuf[2];
                    comboBox_adcref4.SelectedIndex = SerBuf[3];
                    comboBox_adcref5.SelectedIndex = SerBuf[4];
                    comboBox_adcref6.SelectedIndex = SerBuf[5];
                    comboBox_adcref7.SelectedIndex = SerBuf[6];
                    comboBox_adcref8.SelectedIndex = SerBuf[7];
                    this.comboBox_adcref1.SelectedIndexChanged += new System.EventHandler(this.comboBox_adcref1_SelectedIndexChanged);
                    this.comboBox_adcref2.SelectedIndexChanged += new System.EventHandler(this.comboBox_adcref2_SelectedIndexChanged);
                    this.comboBox_adcref3.SelectedIndexChanged += new System.EventHandler(this.comboBox_adcref3_SelectedIndexChanged);
                    this.comboBox_adcref4.SelectedIndexChanged += new System.EventHandler(this.comboBox_adcref4_SelectedIndexChanged);
                    this.comboBox_adcref5.SelectedIndexChanged += new System.EventHandler(this.comboBox_adcref5_SelectedIndexChanged);
                    this.comboBox_adcref6.SelectedIndexChanged += new System.EventHandler(this.comboBox_adcref6_SelectedIndexChanged);
                    this.comboBox_adcref7.SelectedIndexChanged += new System.EventHandler(this.comboBox_adcref7_SelectedIndexChanged);
                    this.comboBox_adcref8.SelectedIndexChanged += new System.EventHandler(this.comboBox_adcref8_SelectedIndexChanged);

                    SerBuf[0] = 0x38;       // get usb serial number command for USB-RLY82
                    transmit(1);
                    receive(8);
                    tempstring = "";
                    for (x = 0; x < 8; x++) tempstring += char.ConvertFromUtf32(SerBuf[x]);
                    textBox_status.Text = "USB-RLY82 found - " + tempstring;
                }
                SerBuf[0] = 0x5B;       // get states command
                transmit(1);
                receive(1);

                if ((SerBuf[0] & 0x01) == 0x01)
                {
                    button_relay1.Text = "RELAY 1 ON";
                    button_relay1.BackColor = Color.Red;
                }
                else
                {
                    button_relay1.Text = "RELAY 1 OFF";
                    button_relay1.BackColor = Color.White;
                }
                if ((SerBuf[0] & 0x02) == 0x02)
                {
                    button_relay2.Text = "RELAY 2 ON";
                    button_relay2.BackColor = Color.Red;
                }
                else
                {
                    button_relay2.Text = "RELAY 2 OFF";
                    button_relay2.BackColor = Color.White;
                }

                SerBuf[0] = 0x5E;       // get digital inputs command
                transmit(1);
                receive(1);
                if ((SerBuf[0] & 0x01) == 0x01) textbox_adc1.BackColor = Color.PaleVioletRed;
                else textbox_adc1.BackColor = Color.Empty;
                if ((SerBuf[0] & 0x02) == 0x02) textbox_adc2.BackColor = Color.PaleVioletRed;
                else textbox_adc2.BackColor = Color.Empty;
                if ((SerBuf[0] & 0x04) == 0x04) textbox_adc3.BackColor = Color.PaleVioletRed;
                else textbox_adc3.BackColor = Color.Empty;
                if ((SerBuf[0] & 0x08) == 0x08) textbox_adc4.BackColor = Color.PaleVioletRed;
                else textbox_adc4.BackColor = Color.Empty;
                if ((SerBuf[0] & 0x10) == 0x10) textbox_adc5.BackColor = Color.PaleVioletRed;
                else textbox_adc5.BackColor = Color.Empty;
                if ((SerBuf[0] & 0x20) == 0x20) textbox_adc6.BackColor = Color.PaleVioletRed;
                else textbox_adc6.BackColor = Color.Empty;
                if ((SerBuf[0] & 0x40) == 0x40) textbox_adc7.BackColor = Color.PaleVioletRed;
                else textbox_adc7.BackColor = Color.Empty;
                if ((SerBuf[0] & 0x80) == 0x80) textbox_adc8.BackColor = Color.PaleVioletRed;
                else textbox_adc8.BackColor = Color.Empty;

                SerBuf[0] = 0x80;       // get adcs
                transmit(1);
                receive(16);
                textbox_adc1.Text = "ADC1 =" + ((SerBuf[0] << 8) + SerBuf[1]).ToString();
                textbox_adc2.Text = "ADC2 =" + ((SerBuf[2] << 8) + SerBuf[3]).ToString();
                textbox_adc3.Text = "ADC3 =" + ((SerBuf[4] << 8) + SerBuf[5]).ToString();
                textbox_adc4.Text = "ADC4 =" + ((SerBuf[6] << 8) + SerBuf[7]).ToString();
                textbox_adc5.Text = "ADC5 =" + ((SerBuf[8] << 8) + SerBuf[9]).ToString();
                textbox_adc6.Text = "ADC6 =" + ((SerBuf[10] << 8) + SerBuf[11]).ToString();
                textbox_adc7.Text = "ADC7 =" + ((SerBuf[12] << 8) + SerBuf[13]).ToString();
                textbox_adc8.Text = "ADC8 =" + ((SerBuf[14] << 8) + SerBuf[15]).ToString();
            }
              
        }

        private void comboBox_comport_SelectedIndexChanged(object sender, EventArgs e)  //opens a comport or network stream corresponding with combobox selection
        {
            if (USB_PORT.IsOpen) USB_PORT.Close();                            // close any existing handle
            USB_PORT.PortName = comboBox_comport.Text;    // retrieves "COMx" from selection in combo box
            USB_PORT.Parity = 0;
            USB_PORT.BaudRate = 19200;
            USB_PORT.StopBits = StopBits.Two;
            USB_PORT.DataBits = 8;
            USB_PORT.ReadTimeout = 50;
            USB_PORT.WriteTimeout = 50;
            USB_PORT.Open();

            SerBuf[0] = 0x5A;       // get version command, returns module id and software version
            transmit(1);
            receive(2);

            if (SerBuf[0] != 255)  // if we recieved the module id  
            {
                init_setup = true;
                textBox_ver.Text = string.Format("{0}", SerBuf[1]);  //print the software version on screen
            }
            connected = true;
        }

        private void transmit(byte write_bytes)
        {
            try
            {
                if (USB_PORT.IsOpen) USB_PORT.Write(SerBuf, 0, write_bytes);      // writes specified amount of SerBuf out on COM port
            }
            catch (Exception)
            {
                USB_PORT.Close();
                connected = false;
                MessageBox.Show("write fail");
            }
        }

        private void receive(byte read_bytes)
        {
            byte x;
            for (x = 0; x < read_bytes && USB_PORT.IsOpen; x++)       // this will call the read function for the passed number times, 
            {                                      // this way it ensures each byte has been correctly recieved while
                try                                // still using timeouts
                {
                    USB_PORT.Read(SerBuf, x, 1);     // retrieves 1 byte at a time and places in SerBuf at position x
                }
                catch (Exception)                   // timeout or other error occured, set lost comms indicator
                {
                    USB_PORT.Close();
                    SerBuf[0] = 255;
                    MessageBox.Show("read fail");
                    connected = false;
                }
            }
        }

        private void button_relay1_Click(object sender, EventArgs e)
        {
            if (button_relay1.Text == "RELAY 1 ON") SerBuf[0] = 0x6F;
            else SerBuf[0] = 0x65;
            transmit(1); 
        }

        private void button_relay2_Click(object sender, EventArgs e)
        {
            if (button_relay2.Text == "RELAY 2 ON") SerBuf[0] = 0x70;
            else SerBuf[0] = 0x66;
            transmit(1);
        }

        private void button_allon_Click(object sender, EventArgs e)
        {
            SerBuf[0] = 0x64;
            transmit(1);
        }

        private void button_alloff_Click(object sender, EventArgs e)
        {
            SerBuf[0] = 0x6E;
            transmit(1);
        }

        private void button_01_Click(object sender, EventArgs e)
        {
            SerBuf[0] = 0x5C;
            SerBuf[1] = 0x55;
            transmit(2);
        }

        private void button10_Click(object sender, EventArgs e)
        {
            SerBuf[0] = 0x5c;
            SerBuf[1] = 0xAA;
            transmit(2);
        }

        private void comboBox_adcref1_SelectedIndexChanged(object sender, EventArgs e)
        {
            SerBuf[0] = 0x81; //set adc voltage ref
            SerBuf[1] = 1;
            SerBuf[2] = (byte)comboBox_adcref1.SelectedIndex;
            transmit(3);
        }

        private void comboBox_adcref2_SelectedIndexChanged(object sender, EventArgs e)
        {
            SerBuf[0] = 0x81; //set adc voltage ref
            SerBuf[1] = 2;
            SerBuf[2] = (byte)comboBox_adcref2.SelectedIndex;
            transmit(3);
        }

        private void comboBox_adcref3_SelectedIndexChanged(object sender, EventArgs e)
        {
            SerBuf[0] = 0x81; //set adc voltage ref
            SerBuf[1] = 3;
            SerBuf[2] = (byte)comboBox_adcref3.SelectedIndex;
            transmit(3);
        }

        private void comboBox_adcref4_SelectedIndexChanged(object sender, EventArgs e)
        {
            SerBuf[0] = 0x81; //set adc voltage ref
            SerBuf[1] = 4;
            SerBuf[2] = (byte)comboBox_adcref4.SelectedIndex;
            transmit(3);
        }

        private void comboBox_adcref5_SelectedIndexChanged(object sender, EventArgs e)
        {
            SerBuf[0] = 0x81; //set adc voltage ref
            SerBuf[1] = 5;
            SerBuf[2] = (byte)comboBox_adcref5.SelectedIndex;
            transmit(3);
        }

        private void comboBox_adcref6_SelectedIndexChanged(object sender, EventArgs e)
        {
            SerBuf[0] = 0x81; //set adc voltage ref
            SerBuf[1] = 6;
            SerBuf[2] = (byte)comboBox_adcref6.SelectedIndex;
            transmit(3);
        }

        private void comboBox_adcref7_SelectedIndexChanged(object sender, EventArgs e)
        {
            SerBuf[0] = 0x81; //set adc voltage ref
            SerBuf[1] = 7;
            SerBuf[2] = (byte)comboBox_adcref7.SelectedIndex;
            transmit(3);
        }

        private void comboBox_adcref8_SelectedIndexChanged(object sender, EventArgs e)
        {
            SerBuf[0] = 0x81; //set adc voltage ref
            SerBuf[1] = 8;
            SerBuf[2] = (byte)comboBox_adcref8.SelectedIndex;
            transmit(3);
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

    }
}
